import React, { Component } from "react";

class HighLow extends Component {
    constructor(props) {
        super(props);

        //Math.random() returns a random value between 0 and 1, multiply it by 1000 to get 0 - 999
        //Use Math.floor() in order to get the nearest integer value down, otherwise it'll be a float, i.e. 50.6 etc.
        //var randomNumber = Math.floor(Math.random() * 1000) 

        this.state = {
            userGuess: 0,
            randomNumber: Math.floor(Math.random() * 1000),
            winOrLoseMessage: "",
            userAttempts: 0,
            timer: 30
        };

        this.getUserGuess = this.getUserGuess.bind(this);
        this.evaluateGuess = this.evaluateGuess.bind(this);
        this.timerTick = this.timerTick.bind(this);
    }

    //This function determines what the user's guess is.
    getUserGuess(e) {
        this.setState({
            userGuess: e.target.value
        });
    }

    //This function will determine if the user guessed the number and display the appropriate message.
    evaluateGuess(e) {
        // console.log("METHOD REACHED!");
        var guess = this.state.userGuess //This is getting our input from when the form is submitted.
        var displayMessage = this.state.winOrLoseMessage

        if (guess < 0 || guess > 999) {
            displayMessage = "You entered an invalid number - try again!"
            // console.log("INVALID!");
        }
        else if (guess < this.state.randomNumber) {
            displayMessage = "Too low!"
            // console.log("TOO LOW!");
        }
        else if (guess > this.state.randomNumber) {
            displayMessage = "Too high!"
            // console.log("TOO HIGH!");
        }
        else {
            displayMessage = "Yay! You got it! Please wait for the page to refresh and we can play again! :)"
            // console.log("YOU WIN!");
        };

        this.setState({
            winOrLoseMessage: displayMessage,
            userAttempts: this.state.userAttempts + 1
        });

        //Clears the number after it's entered and sets the focus back on the textbox so we can try again.
        this._input.focus();
        this._input.value = "";

        // console.log("User attemps:" + this.state.userAttempts);

        e.preventDefault();
    }

    //Timer function for the game, will run for 30 seconds
    timerTick() {
        //User attempts must be greater than 0, otherwise when the page reloads, it'll start ticking immediately.
        if (this.state.userAttempts > 0 && this.state.timer > -1) {
            this.setState({
                timer: this.state.timer - 1
            });
        }

        //If the timer runs out, set the appropriate display message to the user.
        if (this.state.timer <= 0) {
            this.setState({
                winOrLoseMessage: "Time's up! The number was " + this.state.randomNumber + "."
            });
        }
        // console.log("TIMER STARTED!")
    }

    componentDidMount() {
        setInterval(this.timerTick, 1000);  //set timer
        // console.log("componentDidMount: Component just mounted!");
    }

    componentWillUnmount() {
        // console.log("componentWillUnmount: Component is about to be removed from the DOM!");
    }

    shouldComponentUpdate() {
        // console.log("shouldComponentUpdate: Should component update?");

        if (this.state.userAttempts > -1 && this.state.timer >= 0 && this.state.winOrLoseMessage !== "Yay! You got it! Please wait for the page to refresh and we can play again! :)") {
            console.log("shouldComponentUpdate: Component should update!");
            return true;
        }

        else {
            console.log("User has won the game, component must stop executing!");                   

            clearInterval(this.timerTick); //Clear the timer as the user ran out of time.
            // this._input = "Game Over";

            //Reloads the window so the user can play another game with a new number
            //Found at: https://stackoverflow.com/questions/41481522/how-to-refresh-a-page-using-react-route-link , user: sigmapi13
            setTimeout(() => { window.location.reload(false); }, 3000);
            return false;
        }
    }

    componentDidUpdate() {
        // console.log("componentDidUpdate: Component just updated!");
    }


    render() {
        var self = this;
        var timer = this.state.timer;
        var attempts = this.state.userAttempts;

        return (
            <div>
                <h1>High-Low</h1>
                <div id="rules">
                    <h4>
                        How to Play: <br />
                        ~~~~~~~~~~~~ <br />
                        A number in between 0 and 999 (inclusive) will be generated.<br />
                        You have 30 seconds to guess the number.<br />
                        If you guess the number before the timer runs out, you win!<br />
                        If not, you lose the round and the computer will generate a new number.<br />
                        Good luck!
                    </h4>
                </div>


                {/* <p id="testNumber">The random number is: {this.state.randomNumber}</p> */}

                <form onSubmit={this.evaluateGuess}>
                    <input type="number" onChange={this.getUserGuess}
                        ref={
                            function (el) {
                                self._input = el; //We can now access our input via self._input anywhere inside our component.
                            }
                        }
                        placeholder="Enter guess"></input>
                    <button type="submit">Guess</button>
                </form>

                <p className="alignCenter" id="result">{this.state.winOrLoseMessage}</p>

                <div id="mainDiv">
                    <div id="leftDiv">
                        <h2 id="timerPosition">Time Left: {timer}</h2>
                    </div>

                    <div id="rightDiv">
                        <h2 id="attemptsPosition">Attempts Made: {attempts}</h2>
                    </div>
                </div>
                <div id="clearDivStyle"></div>
            </div>
        );
    }
}

export default HighLow;